"use strict";

exports.promiseFinally = function (promise, fn) {
  var success = function success(result) {
    fn();
    return result;
  };

  var error = function error(e) {
    fn();
    return Promise.reject(e);
  };

  return Promise.resolve(promise).then(success, error);
};
/**
 * Converts any value to Error.
 * @param {*} value
 * @returns {Error}
 */


exports.toError = function (value) {
  value = typeof value === 'function' ? value() : value;
  return typeof value === 'string' ? new Error(value) : value;
};